<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Product extends Model 
{

    protected $table = 'products';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('title', 'subtitle', 'slug', 'code', 'is_active', 'is_featured', 'is_maintenance', 'logo_url', 'banner_url', 'helper_url', 'description', 'long_description', 'ordered');

    public function user_input()
    {
        return $this->hasOne('Product\UserInput', 'id');
    }

    public function category()
    {
        return $this->belongsTo('App\Models\Category');
    }

    public function seo()
    {
        return $this->hasOne('Product\SEO', 'product_id');
    }

}